/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.ARPProcessEvent;
import apiipc.generated.events.ARPProcessEventListener;
import apiipc.generated.sim.ARPProcess;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPProcessEventRegistry
extends IPCEventRegistry {
    protected Set<ARPProcessEventListener> globalListeners = new HashSet<ARPProcessEventListener>();
    protected Map<String, Set<ARPProcessEventListener>> specificObjectListeners = new HashMap<String, Set<ARPProcessEventListener>>();

    public ARPProcessEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "ARPProcess";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        ARPProcessEvent aRPProcessEvent = null;
        if (string.equalsIgnoreCase("arpEntryAdded")) {
            aRPProcessEvent = new ARPProcessEvent.ArpEntryAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("arpEntryRemoved")) {
            aRPProcessEvent = new ARPProcessEvent.ArpEntryRemoved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("foundTakingMyIp")) {
            aRPProcessEvent = new ARPProcessEvent.FoundTakingMyIp(iPCEventLTV);
        } else if (string.equalsIgnoreCase("foundMyIpTaken")) {
            aRPProcessEvent = new ARPProcessEvent.FoundMyIpTaken(iPCEventLTV);
        } else {
            return;
        }
        for (ARPProcessEventListener object : this.globalListeners) {
            object.handleEvent(aRPProcessEvent);
        }
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(aRPProcessEvent.objectUUID.toString());
        if (set != null) {
            for (ARPProcessEventListener aRPProcessEventListener : set) {
                aRPProcessEventListener.handleEvent(aRPProcessEvent);
            }
        }
    }

    public void addListenerFiltered(ARPProcessEventListener aRPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("arpEntryAdded");
                this.register("arpEntryRemoved");
                this.register("foundTakingMyIp");
                this.register("foundMyIpTaken");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(aRPProcessEventListener);
    }

    public void addSpecificListenerFiltered(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess, List<String> list) throws IOException {
        UUID uUID = aRPProcess.getObjectUUID();
        String string = uUID.toString();
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<ARPProcessEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "arpEntryAdded");
                this.register(uUID, "arpEntryRemoved");
                this.register(uUID, "foundTakingMyIp");
                this.register(uUID, "foundMyIpTaken");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(aRPProcessEventListener);
    }

    public void removeListenerFiltered(ARPProcessEventListener aRPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("arpEntryAdded");
                this.deregister("arpEntryRemoved");
                this.deregister("foundTakingMyIp");
                this.deregister("foundMyIpTaken");
            }
            this.globalListeners.remove(aRPProcessEventListener);
        }
    }

    public void removeSpecificListenerFiltered(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess, List<String> list) throws IOException {
        UUID uUID = aRPProcess.getObjectUUID();
        String string = uUID.toString();
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "arpEntryAdded");
            this.deregister(uUID, "arpEntryRemoved");
            this.deregister(uUID, "foundTakingMyIp");
            this.deregister(uUID, "foundMyIpTaken");
            set.remove(aRPProcessEventListener);
        }
    }

    public void addListener(ARPProcessEventListener aRPProcessEventListener) throws IOException {
        this.addListenerFiltered(aRPProcessEventListener, null);
    }

    public void addListener(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess) throws IOException {
        this.addSpecificListenerFiltered(aRPProcessEventListener, aRPProcess, null);
    }

    public void removeListener(ARPProcessEventListener aRPProcessEventListener) throws IOException {
        this.removeListenerFiltered(aRPProcessEventListener, null);
    }

    public void removeListener(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess) throws IOException {
        this.removeSpecificListenerFiltered(aRPProcessEventListener, aRPProcess, null);
    }
}

